using UnityEngine;
using System;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.IO;

namespace hiveAdiz
{
	public class AdizError {

		public enum ErrorCode : int {

            SUCCESS = 0,
  
            /**
			* Common error
			*/
			INVALID_PARAM       = -1, // 잘못된 파라미터
			NOT_SUPPORTED       = -2, // 지원하지 않음
			IN_PROGRESS         = -3, // 프로세스 진행중 상태
			NETWORK             = -4, // 네트워크 에러
			NEED_INITIALIZE     = -5, // 초기화 필요
			RESPONSE_FAIL       = -6, // 응답 실패
			TIMEOUT             = -7, // 네트워크 타임아웃

			UNKNOWN             = -99, // 알수 없는 에러

			/**
			* Errors related to mediation
			*/
			NEED_LOAD               = -101, // 광고가 로드 되지 않았음
			NEED_RELOAD             = -102, // 광고 노출 시간 만료로 인한 다시 로드 필요
			NOT_ENOUGH_INVENTORY    = -103, // 미디에이션 응답은 성공하였으나 인벤토리 부족으로 채워진 광고가 없음
			MISSING_APPID           = -104, // 미디에이션 요청을 위한 앱아이디 오류
			INTERNAL_NETWORK_ERROR  = -105, // 미디에이션 네트워크 관련 에러
			INVALID_UNIT_ID         = -106, // 잘못된 Unit Id
			MEDIATION_NO_FILL       = -107, // 미디에이션 어탭터가 광고 요청을 처리하지 못함
			ALREADY_LOADED          = -108, // 이미 로드된 상태
        	CANNOT_REQUEST_ADS      = -109, // 광고를 요청할 수 없음(GDPR 지역에서 미동의 상태 또는 GDPR 16세 미만 사용자)

			/**
         	* GDPR Consent error
         	*/
        	GDPR_CONSENT_ERROR              = -201, // GDPR 동의 에러
        	IS_NOT_PRIVACY_OPTIONS_REQUIRED = -202, // GDPR 재동의 팝업 노출 필요없음
        }

		public ErrorCode errorCode = ErrorCode.SUCCESS;

		public String errorMessage = "SUCCESS";


		public AdizError() {
		}


		public AdizError(int errorCode, String errorMessage) {

			if (Enum.IsDefined(typeof(ErrorCode), errorCode))
				this.errorCode = (ErrorCode)errorCode;
			else
				this.errorCode = ErrorCode.UNKNOWN;

			this.errorMessage = errorMessage;
		}

		public AdizError(ErrorCode errorCode, String errorMessage) {

			this.errorCode = errorCode;
			this.errorMessage = errorMessage;
		}


		public AdizError(JSONObject resJsonParam) {

			int _errorCode = 0;
			resJsonParam.GetField (ref _errorCode, "errorCode");

			if (Enum.IsDefined(typeof(ErrorCode), _errorCode))
				this.errorCode = (ErrorCode)_errorCode;
			else
				this.errorCode = ErrorCode.UNKNOWN;

			resJsonParam.GetField (ref this.errorMessage, "errorMessage");
		}


		public Boolean isSuccess() {
			
			return (this.errorCode == ErrorCode.SUCCESS);
		}

		public String toString() {

			StringBuilder sb = new StringBuilder ();

			sb.Append ("AdizError { errorCode = ");
			sb.Append (this.errorCode);
			sb.Append (", msg = ");
			sb.Append (this.errorMessage);
			sb.Append (" }\n");

			return sb.ToString ();
		}
	}
}




